/*
 *  i2c-algo-mn2ws.h i2c driver algorithms for Panasonic MN2WS series adapters
 *    (C) Copyright 2008 Panasonic Corporation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef I2C_MN2WS_INTERNAL_H__INCLLUDED /* [ */
#define I2C_MN2WS_INTERNAL_H__INCLLUDED 1

#include <linux/wait.h>
#include <linux/i2c.h>

#define IO_SIZE (4 * 9)	/* 32bit * 9 Register = 36 Byte */

/*----- Register Offset -----*/
#define I2C_MN2WS_DTRM  (0x00)
#define I2C_MN2WS_DREC  (0x04)
#define I2C_MN2WS_MYAD  (0x08)
#define I2C_MN2WS_CLK   (0x0C)
#define I2C_MN2WS_BRST  (0x10)
#define I2C_MN2WS_HOLD  (0x14)
#define I2C_MN2WS_BSTS  (0x18)
#define I2C_MN2WS_NOISE (0x1C)
#define I2C_MN2WS_SETUP (0x20)
#define I2C_MN2WS_RMSK  (0x3C)

/*----- IICnDTRM -----*/
#define I2C_MN2WS_DTRM_IRQEN     (0x00000800)
#define I2C_MN2WS_DTRM_STA       (0x00000400)
#define I2C_MN2WS_DTRM_STO       (0x00000200)
#define I2C_MN2WS_DTRM_ACK       (0x00000100)
#define I2C_MN2WS_DTRM_DATA      (0x000000FF)

/*----- IICnDREC -----*/
#define I2C_MN2WS_DREC_MODE      (0x00006000)
#define I2C_MN2WS_DREC_STS       (0x00001000)
#define I2C_MN2WS_DREC_LRB       (0x00000800)
#define I2C_MN2WS_DREC_AAS       (0x00000400)
#define I2C_MN2WS_DREC_LAB       (0x00000200)
#define I2C_MN2WS_DREC_BB        (0x00000100)
#define I2C_MN2WS_DREC_DATA      (0x000000FF)
#define I2C_MN2WS_DREC_STATUS    (0x00001F00)

/*----- IICnMYAD -----*/
#define I2C_MN2WS_MYAD_ADDR      (0x0000003F)

/*----- IICnCLK -----*/
#define I2C_MN2WS_CLK_LW         (0x7FFF0000)
#define I2C_MN2WS_CLK_PLS        (0x0000FFFF)

/*----- IICnBRST -----*/
#define I2C_MN2WS_BRST_FOEN      (0x00000002)
#define I2C_MN2WS_BRST_BRST      (0x00000001)

/*----- IICnHOLD -----*/
#define I2C_MN2WS_HOLD_HOLDCNT   (0x000001FF)

/*----- IICnBSTS -----*/
#define I2C_MN2WS_BSTS_SDA       (0x00000002)
#define I2C_MN2WS_BSTS_SCL       (0x00000001)

/*----- IICnNOISE -----*/
#define I2C_MN2WS_NOISE_WIDTH    (0x0000001F)

/*----- IICnSETUP -----*/
#define I2C_MN2WS_SETUP_SETUPCNT (0x0000007F)

/*
 * Low phase rate of SCL
 *    (LOW part) = (Whole) * IIC_LOW_DUTY
 *
 */
#define I2C_MN2WS_LOW_DUTY	1/2    /* [CAUTION] Don't put this macro in parentheses */

/*
 * HOLD time [nsec]
 */
#define I2C_MN2WS_HOLD_TIME	(330U)

/*
 * Noise Width Cnt
 */
#define I2C_MN2WS_NOISE_WIDTH_CNT	(0x7)

/*
 * Setup Time Cnt
 */
#define I2C_MN2WS_SETUPCNT	(0x20)

#define I2C_MN2WS_ADAP_MAX (5)

/* execution mode */
#define I2C_MN2WS_EXEC_START	0
#define I2C_MN2WS_EXEC_READ	1
#define I2C_MN2WS_EXEC_SEND	2
#if defined(CONFIG_I2C_SLAVE)
#define I2C_MN2WS_EXEC_SLAVE_WAIT	3
#define I2C_MN2WS_EXEC_SLAVE_SEND	4
#define I2C_MN2WS_EXEC_SLAVE_RECV	5
#define I2C_MN2WS_EXEC_IDLE			6
#endif//defined(CONFIG_I2C_SLAVE)

#if defined(CONFIG_I2C_SLAVE)
#define I2C_SLAVE_TIMEOUT_VALUE		500
#endif //defined(CONFIG_I2C_SLAVE)


struct i2c_algo_mn2ws_exec_info {
	unsigned short	mode;		/* execution mode */
	unsigned short	flags;		/* control flag */
	unsigned char	*buf;		/* data buffer pointer */
	unsigned short	len;		/* data length */
	unsigned short	cnt;		/* send/recv counter */
	int				result;		/* execution result */
	unsigned short	cnt_bak;	/* counter backup for watch */
	unsigned short	watch_timeflag;	/* watch timer flag */
	int				watch_timeval;	/* watch timer value */
	struct timer_list	watch_timer;	/* execution watch timer */
	
#if defined(CONFIG_I2C_SLAVE)
	unsigned char		slave_cond;
#endif//defined(CONFIG_I2C_SLAVE)
};

struct i2c_algo_mn2ws_data {
	unsigned long     base;	/* Register Base Address */
	void             *iomap_base;	/* IOREMAP : Register Base Address */
	int               irq;	/* IRQ No. */
	int               irq_event;
	wait_queue_head_t wait;	/* for IRQ handler */
	int               rate;	/* Default BusRate */
	spinlock_t        lock;	/* lock for controller */
	unsigned int      udelay;	/* usec delay */
	unsigned short    wr2rd_wait_time;	/* read wait time just after write (msec) */

	struct i2c_algo_mn2ws_exec_info  exec_info;	/* execution information */
#if defined(CONFIG_I2C_SLAVE)
	int			slave_event;
	wait_queue_head_t	slave_wait;
#endif//defined(CONFIG_I2C_SLAVE)
};

#define I2C_MN2WS_BUS_POLLING_CNT		(0x10000)

#endif /* ] I2C_MN2WS_INTERNAL_H__INCLLUDED */
